﻿using System;
using System.Text;
using System.Xml;

namespace AHOBPR_Job_Runner.DasXml
{
    public enum MilitaryStatusEnum { Qualifying, Current };

    [Serializable]
    public class MilitarySummary
    {
        public String MilitaryBranchName { get; set; }
        public MilitaryStatusEnum MilitaryStatus { get; set; }
         
        public void GetXml(XmlWriter writer)
        {
            String prefix = "nc";
            writer.WriteStartElement(prefix, "PersonMilitarySummary", prefix);
            writer.WriteWhitespace("\r\n\t\t\t\t");

            //Military Branch Name:
            {
                writer.WriteElementString(prefix, "MilitaryBranchName", prefix, MilitaryBranchName);
                writer.WriteWhitespace("\r\n\t\t\t\t");
            }

            //Military Status:
            {
                writer.WriteStartElement(prefix, "MilitaryStatus", prefix);
                writer.WriteWhitespace("\r\n\t\t\t\t\t");
                {
                    //Status Text:
                    {
                        if (MilitaryStatus == MilitaryStatusEnum.Current)
                        {
                            writer.WriteElementString(prefix, "StatusText", prefix, "Current or Last Service Affiliation");
                        }
                        else
                        {
                            writer.WriteElementString(prefix, "StatusText", prefix, "Service Affiliation of the Last Qualifying Deployment");
                        }
                        writer.WriteWhitespace("\r\n\t\t\t\t");
                    }
                }
                writer.WriteEndElement();
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            writer.WriteEndElement();
        }
    }
}